#! /bin/bash

# 1.install uninstall
# 2. start stop service
# 3. check service is installed
#
#

INSTALL_BASEDIR=/
FILESYSTEM_PATH=${INSTALL_BASEDIR}/etc/cp/
CP_AGENT_SERVICE_NAME=nano_agent

KILLSWITCH_PATH=${FILESYSTEM_PATH}workloadProtection/killswitch

#wlp start script file path
WLP_START_FILE= #${INSTALL_BASEDIR}./nano-agent-wlp-start.sh

#wlp crash file path
WLP_CRASH_FILE_PATH=${INSTALL_BASEDIR}./var/log/

#不同颜色的提示信息
function msg_error()
{
	printf "\33[31m$1\33[0m"
}

function msg_ask()
{
	printf "\33[33m$1\33[0m"
}

function msg_info()
{
	printf "\33[32m$1\33[0m"
}

#print script command 
function usage()
{
	echo "Options:"
	printf " --install    : install check point agent \n"
	printf " --uninstall  : uninstall check point agent \n"
	printf " --enable     : enable check point agent service\n"
	printf " --disable    : disable check point agent service\n"
	printf " --start      : check point agent killswitch=0\n"
	printf " --stop       : check point agent killswitch=1\n"
	printf " --status     : status of check point agent killswitch\n"
	printf " --is-enable  : status of check point agent enable\n"
	printf " --is-install : status of check point agent install\n"
	printf " --wlp-run    : running wlp \n"
	printf " --wlp-clean  : clear wlp crash file in the install path ./var/log \n"
}



function agent_install()
{
   #./cp-provision-integration-vms.sh --install --offline_mode --max-log-size-kb 2048 --max-log-rotation 1
   # install root directroy
   #export BASEDIR=${INSTALL_BASEDIR}
   #INSTALL_PARAM=--install --offline_mode --max-log-size-kb 2048 --max-log-rotation 1
   CURRENT_PATH=`pwd`
   echo ${CURRENT_PATH}
   FILE_PATH=${CURRENT_PATH}/cp-provision-integration-vms.sh
   
   #check file is not exist!
   if [ ! -x "${FILE_PATH}" ]; then
   	msg_error "${FILE_PATH}is not exist!"
   	return 1
   fi
   
#   last_switch=0
   
#   agent_is_installed
#   ret=$?
   
#   if  [ "${ret}" = "0" ]; then
#      echo "Point Nano Agent is installed"
		
#		last_switch=$(cat ${KILLSWITCH_PATH})
#		echo "last_switch=${last_switch}"
#       agent_uninstall
#   fi
    
   ${FILE_PATH} --install --offline_mode --max-log-size-kb 2048 --max-log-rotation 1 
   
   echo "/tmp/*" > $FILESYSTEM_PATH/workloadProtection/filemon/whitelist
   echo "/mnt/nfs/*" >> $FILESYSTEM_PATH/workloadProtection/filemon/whitelist
   #echo "/proc/net/dev" >> $FILESYSTEM_PATH/workloadProtection/filemon/whitelist
   #echo "/proc/net/route" >> $FILESYSTEM_PATH/workloadProtection/filemon/whitelist
   #echo "/etc/udev/rules.d/70-persistent-net.rules" >> $FILESYSTEM_PATH/workloadProtection/filemon/whitelist
   #echo "/etc/sysconfig/network-scripts/*" >> $FILESYSTEM_PATH/workloadProtection/filemon/whitelist
   #echo "/etc/ppp/*" >> $FILESYSTEM_PATH/workloadProtection/filemon/whitelist
   #echo "/etc/netplan/*" >> $FILESYSTEM_PATH/workloadProtection/filemon/whitelist
   #echo "/etc/resolv.conf" >> $FILESYSTEM_PATH/workloadProtection/filemon/whitelist
   echo "/opt/NVMS/*" >> $FILESYSTEM_PATH/workloadProtection/filemon/whitelist
   echo "/opt/upgrade.sh" >> $FILESYSTEM_PATH/workloadProtection/filemon/whitelist
   echo "/etc/init.d/shutdown_os.sh" >> $FILESYSTEM_PATH/workloadProtection/filemon/whitelist
   #echo "/opt/NVMS/configInfo/Config/ipmaintain.sh" >> $FILESYSTEM_PATH/workloadProtection/filemon/whitelist
   echo "/etc/rc.local" >> $FILESYSTEM_PATH/workloadProtection/filemon/whitelist
   echo "/opt/NVMS_2.0.0.tar.gz" >> $FILESYSTEM_PATH/workloadProtection/filemon/whitelist
   echo "/opt/apache-tomcat/*" >> $FILESYSTEM_PATH/workloadProtection/filemon/whitelist



   echo "^ping -c 1 [a-zA-Z0-9\-\.]+\s+2>&1$" > $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/usr/sbin/dmidecode.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^dmidecode.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^sudo dmidecode.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^hdparm.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^grep.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^awk.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^df.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^mount.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^umount.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^blkid.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^fsck.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^mkdir.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^lshw.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^sync.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^timedatectr.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^pause$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^cp.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^rm.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^dd.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^echo.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^haapibin.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^sudo ntpdate.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^crontab.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^sudo service cron.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^hwclock.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^systemctl.*sshd\.service$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^systemctl.*mysql\.service$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^service mysql.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^mysql.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^mysqldump.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/ssh.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^shutdown.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^ldconfig.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/tmp/Clear_NIC_Route.sh" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/tmp/NetworkConfigApply.sh" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/tmp/Reset_RouteTable_.*\.sh$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/tmp/setIPTables.sh" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/ConfigDevBasicServer-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/AuthenticationServer-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/MediaTransferServer-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/StorageServer-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/AlarmServer-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/TVWallServer-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/JoinServer-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/IntelligentAnalysisServer-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/ConfigServer-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/UpperCascadeGW-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/LowerCascadeGW-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/StreamServerGW-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/PicWebServer-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/LowerGAT1400-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/UpperGAT1400Server-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/etc/init.d/ApplicationServer-daemon.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/sbin/iptables.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^ip route.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^route.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^ifconfig.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^printf.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^sudo pstack.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/opt/upgrade.sh.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/usr/bin/tar.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/usr/bin/chmod.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/usr/bin/rm.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/usr/bin/dpkg.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^systemctl status sshd.service > /opt/NVMS/nvmsTemp.txt$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^find.*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^ls .*$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   echo "^/opt/NVMS/OpenCoreServerAndClinet.sh$" >> $FILESYSTEM_PATH/workloadProtection/antisi/whitelist
   
   
# 默认关闭状态
#   if [ "${last_switch}" = "1" ] ; then
        agent_stop_without_reboot
#   fi

};

function agent_uninstall()
{
   # /etc/cp/scripts/cp-agent-uninstall.sh
   UNINSTALL_FILE=${FILESYSTEM_PATH}/scripts/cp-agent-uninstall.sh
   if [ ! -x "${UNINSTALL_FILE}" ]; then
   	echo "${UNINSTALL_FILE} is not exist!"
   	return 1
   fi
   
    ${UNINSTALL_FILE} 
    if test "$?" = "0"; then
        echo "Check Point Nano Agent successfully uninstalled"
    else
        echo "Failed to uninstall Check Point Nano Agent"
        return 1
    fi
   
   
}

function agent_is_installed()
{
  #sudo systemctl list-unit-files|grep nano_agent
  # =0 install
  #  1 uninstall
  systemctl list-unit-files|grep ${CP_AGENT_SERVICE_NAME} > /dev/null
  ret=$?
  if test "${ret}" = "0"; then
        echo "Point Nano Agent is installed"
  else 
        echo "Point Nano Agent is not installed "
  fi
  return ${ret}
}


function agent_start()
{
#  service  ${CP_AGENT_SERVICE_NAME}  start > /dev/null
  echo "0" > ${KILLSWITCH_PATH}
  ret=$?
  if test "${ret}" = "0"; then
        echo "Point Nano Agent is started "
        rm -f /opt/NVMS/nvms.run
	/etc/init.d/shutdown_os.sh reboot &
  else
        echo "Failed Point Nano Agent  is started"
  fi
  return ${ret}
  
}

function agent_stop()
{
#  service  ${CP_AGENT_SERVICE_NAME}  stop > /dev/null
  echo "2" > ${KILLSWITCH_PATH}
  ret=$?
  if test "${ret}" = "0"; then
        echo "Point Nano Agent is success stop"
        rm -f /opt/NVMS/nvms.run
        /etc/init.d/shutdown_os.sh reboot &

  else
        echo "Failed Point Nano Agent is  start"
  fi
  return ${ret}
}

function agent_stop_without_reboot()
{
#  service  ${CP_AGENT_SERVICE_NAME}  stop > /dev/null
  echo "2" > ${KILLSWITCH_PATH}
  ret=$?
  if test "${ret}" = "0"; then
        echo "Point Nano Agent is success stop"

  else
        echo "Failed Point Nano Agent is  start"
  fi
  return ${ret}
}

function agent_status()
{
#last_switch  0 run switch
#   2  stop 
	last_switch=$(cat ${KILLSWITCH_PATH})
	echo "last_switch=${last_switch}"
	return ${last_switch}
}


function agent_enable()
{
  systemctl enable ${CP_AGENT_SERVICE_NAME}  > /dev/null
  ret=$?
  if test "${ret}" = "0"; then
        echo "Point Nano Agent service is success enable"
  else
        echo "Failed Point Nano Agent service is  enable"
  fi
  return ${ret}
  
}

function agent_disable()
{
  systemctl disable ${CP_AGENT_SERVICE_NAME}  > /dev/null
  ret=$?
  if test "${ret}" = "0"; then
        echo "Point Nano Agent service is success disable"
  else
        echo "Failed Point Nano Agent service is  disable"
  fi
  return ${ret}
}



function agent_is_enable()
{
#sudo systemctl is-enabled nano_agent
# =0 enable
#  1 disable
  systemctl is-enabled ${CP_AGENT_SERVICE_NAME} > /dev/null
  ret=$?
  if [ "${ret}" = "0" ]; then
        echo "Point Nano Agent service is enable"
  elif [ "${ret}" = "1" ]; then
  	echo "Point Nano Agent service is disable"
  else
        echo "Point Nano Agent service is disable "
  fi
  return ${ret}
}

function agent_is_running()
{
#sudo service nano_agent status > /dev/null
#$? =0 表示在运行
#   =1 服务未知或不存在
#   =3 服务暂停 

  service ${CP_AGENT_SERVICE_NAME} status > /dev/null
  ret=$?
  
  if [ "${ret}" = "0" ]; then
        echo "Point Nano Agent service is running"
  elif [ "${ret}" = "1" ]; then
  	echo "Point Nano Agent service is unknow"
  elif [ "${ret}" = "3" ]; then
  	echo "Point Nano Agent service is stop"
  else
        echo "Point Nano Agent service is unknow "
  fi
  
  
  return ${ret}
}



# install Check Point Agent
function run()
{
    if [ -z "$1" ]; then
        usage
    elif [ "--install" = "$1" ] || [ "-i" = "$1" ]; then
        agent_install 
    elif [ "--start" = "$1" ] || [ "-r" = "$1" ]; then
        agent_start
    elif [ "--stop" = "$1" ] || [ "-q" = "$1" ]; then
        agent_stop
    elif [ "--uninstall" = "$1" ] || [ "-u" = "$1" ]; then
        agent_uninstall
    elif [ "--is-install" = "$1" ]; then
        agent_is_installed
    elif [ "--is-enable" = "$1" ]; then
        agent_is_enable
    elif [ "--status" = "$1" ]; then
        agent_status
    elif [ "--enable" = "$1" ]; then
         agent_enable
    elif [ "--disable" = "$1" ] ; then
         agent_disable
    elif [ "--wlp-run" = "$1" ] ; then
         echo "" #sh  ${WLP_START_FILE}
    elif [ "--wlp-clean" = "$1" ] ; then
    #删除./var/log/下所有crash文件，
        rm -f ${WLP_CRASH_FILE_PATH}wlp-crash.*
    else
        usage
    fi
}



#load_paths
run "${@}"

exit $?


















