#! /bin/bash

if [ -z "$1" ] || [ -z "$2" ] ; then
	printf "\33[33m upgrade.sh {UpgradeFile} {ProductType:A600E/A600SE/S300E/A510-MS/A510S-MS/A510-MTC/A510S-MTC/A510-MTSC/A510S-MTSC/A510-MTS/A510-SGW/A510-LGW/A510-UGW if-AI-Ubuntu18.04.3:A300-MTC/A300-TS/A300-PMS/TD-A608E/A400-MTC/A510-DGW if-TY:HVM-HRS2400/HVM-HSS2100/HVM-HMS2100/HVM-HGS2100/HVM-HSS2000L/HVM-HCO2000/HVM-HDM2100}\33[0m\n"
	exit 2
fi

LOG_FILE="/opt/NVMS/upgrade.log"
mkdir -p /opt/NVMS/

function PrintLog()
{
    if [ $# -eq 0 ]; then
        return 1
    fi
    echo "$1" >> ${LOG_FILE}
    if [[ $# -eq 2 && $2 == "stdout" ]]; then
        echo "$1"
    fi
    return 1
}

PrintLog ""
PrintLog "###############################################################"
DATE=`date "+%Y-%m-%d %H:%M:%S"`
PrintLog "$DATE"

if [ $2 == "A600E" ] || [ $2 == "A600SE" ]; then
	echo $2
	CustomName="A600E"
elif [ $2 == "S300E" ]; then
	echo $2
	CustomName="S300E"
elif [ $2 == "A510-MS" ] || [ $2 == "A510S-MS" ]; then
	echo $2
	CustomName="A510-MS"
elif [ $2 == "A510-MTS" ]; then
	echo $2
	CustomName="A510-MTS"
elif [ $2 == "A510-MTC" ] || [ $2 == "A510S-MTC" ]; then
	echo $2
	CustomName="A510-MTC"
elif [ $2 == "A510-MTSC" ] || [ $2 == "A510S-MTSC" ]; then
	echo $2
	CustomName="A510-MTSC"
elif [ $2 == "A510-SGW" ]; then
	echo $2
	CustomName="A510-SGW"
elif [ $2 == "A510-LGW" ]; then
	echo $2
	CustomName="A510-LGW"
elif [ $2 == "A510-UGW" ]; then
	echo $2
	CustomName="A510-UGW"
elif [ $2 == "HVM-HRS2400" ]; then
	echo $2
	CustomName="HVM-HRS2400"
elif [ $2 == "HVM-HSS2100" ]; then
	echo $2
	CustomName="HVM-HSS2100"
elif [ $2 == "HVM-HMS2100" ]; then
	echo $2
	CustomName="HVM-HMS2100"
elif [ $2 == "A300-MTC" ]; then
	echo $2
	CustomName="A300-MTC"
elif [ $2 == "A300-TS" ]; then
	echo $2
	CustomName="A300-TS"
elif [ $2 == "A300-PMS" ]; then
	echo $2
	CustomName="A300-PMS"
elif [ $2 == "TD-A608E" ]; then
	echo $2
	CustomName="TD-A608E"
elif [ $2 == "A400-MTC" ]; then
	echo $2
	CustomName="A400-MTC"
elif [ $2 == "HVM-HGS2100" ]; then
	echo $2
	CustomName="HVM-HGS2100"
elif [ $2 == "HVM-HSS2000L" ]; then
	echo $2
	CustomName="HVM-HSS2000L"
elif [ $2 == "HVM-HCO2000" ]; then
	echo $2
	CustomName="HVM-HCO2000"
elif [ $2 == "HVM-HDM2100" ]; then
	echo $2
	CustomName="HVM-HDM2100"
elif [ $2 == "A510-DGW" ]; then
	echo $2
	CustomName="A510-DGW"
else
	printf "\33[33m upgrade.sh {UpgradeFile} {ProductType:A600E/A600SE/S300E/A510-MS/A510S-MS/A510-MTC/A510S-MTC/A510-MTSC/A510S-MTSC/A510-MTS/A510-SGW/A510-LGW/A510-UGW if-AI-Ubuntu18.04.3:A300-MTC/A300-TS/A300-PMS/TD-A608E/A400-MTC if-TY:AVM-HRS2400/AVM-HSS2100/AVM-HMS2100/AVM-HGS2100/AVM-HSS2000L/AVM-HCO2000/HVM-HDM2100}\33[0m\n"
	exit 2
fi

if [ $# -lt 3 ] ; then
	echo "param less than 3"
	SpecialType=$2
else
	SpecialType=$3
fi 

UpgradeFile=$1
ProductType=$2
UpgradePath=/tmp/upgrade/
PreUpgradeSh=/tmp/upgrade/preupgrade.sh
config_start="service ConfigDevBasicServer-daemon start"
config_start_process="/opt/NVMS/ConfigDevBasicServer daemon &"
config_ip_maintain="/opt/NVMS/configInfo/Config/ipmaintain.sh"
find_file=/etc/rc.local
find_file_ex=/etc/rc.d/rc.local
tomcat_start="/opt/apache-tomcat/bin/startup.sh"
file_etc_modules="/etc/modules"
find_profile=/etc/profile
ulimit_str="ulimit -c 0"
version_info=`lsb_release -a`
version_ubutnu20="Ubuntu 20.04"
version_ubutnu18="Ubuntu 18.04"
version_centos="CentOS"
agent_cp="export LD_PRELOAD=/usr/lib/libwlp-core.so"

PrintLog "UpgradeFile=${UpgradeFile}  ProductType=${ProductType}  SpecialType=${SpecialType}"
PrintLog "lsb_release -a: ${version_info}"

funconfig()
{
	echo $config_start >> $find_file
}

funprocessconfig()
{
	echo $config_start_process >> $find_file
}

funprocessconfig_ex()
{
	echo $config_start_process >> $find_file_ex
}

funipmaintainconfig()
{
	echo $config_ip_maintain >> $find_file
}

funipmaintainconfig_ex()
{
	echo $config_ip_maintain >> $find_file_ex
}

funexportLibPath()
{
	rm -rf /etc/test_bk
	sed '/touch/a\ldconfig' $find_file >> /etc/test_bk
	mv -f /etc/test_bk $find_file
	chmod 777 $find_file
	#echo "ldconfig" >> $find_file
}

funexportLibPath_ex()
{
	rm -rf /etc/test_bk
	sed '/touch/a\ldconfig' $find_file_ex >> /etc/test_bk
	mv -f /etc/test_bk $find_file_ex
	chmod 777 $find_file_ex
	#echo "ldconfig" >> $find_file_ex
}

funtomcat()
{
	echo $tomcat_start >> $find_file
}

funulimit()
{
	echo $ulimit_str >> $find_profile
}

funbond()
{
	echo "bonding" >> $file_etc_modules
}

StopServer()
{
	/etc/init.d/ConfigDevBasicServer-daemon stop
	/etc/init.d/ConfigServer-daemon stop
	/etc/init.d/AuthenticationServer-daemon stop
	/etc/init.d/MediaTransferServer-daemon stop
	/etc/init.d/StorageServer-daemon stop
	/etc/init.d/AlarmServer-daemon stop
	/etc/init.d/TVWallServer-daemon stop
	/etc/init.d/JoinServer-daemon stop
	/etc/init.d/IntelligentAnalysisServer-daemon stop
	/etc/init.d/UpperCascadeGW-daemon stop
	/etc/init.d/LowerCascadeGW-daemon stop
	/etc/init.d/RtspServerGW-daemon stop
	/etc/init.d/StreamServerGW-daemon stop
	/etc/init.d/ZlMedia-daemon stop
	/etc/init.d/websocket_rtsp_proxy-daemon stop
	/etc/init.d/LowerGAT1400-daemon stop
	/etc/init.d/UpperGAT1400Server-daemon stop
	/etc/init.d/PicWebServer-daemon stop
	/etc/init.d/ApplicationServer-daemon stop
	/etc/init.d/MonitorClient-daemon stop	
}

#首先要卸载agent，否则会阻止升级脚本正常安装
#uninstall Check Point Agent
#if [ -f /opt/NVMS/cp-provision-integration-vms.sh ]  && [ -f /opt/NVMS/cp_agent_ctrl.sh ] ; then
if [ -f /etc/cp/workloadProtection/killswitch ]; then
    echo "set killswitch 2"
    echo "2" > /etc/cp/workloadProtection/killswitch
#   /opt/NVMS/cp_agent_ctrl.sh --stop
#   echo "uninstall Check Point Agent"
#   /opt/NVMS/cp_agent_ctrl.sh --uninstall
fi

#删除包含LD_PRELOAD libwlp-core.so
sed -i '/LD_PRELOAD.*libwlp-core.so/d' $find_file
sed -i '/\/opt\/NVMS\/cp_agent_ctrl.sh --wlp-clean/d' $find_file

if [ ! -f "$UpgradeFile" ]; then
	printf "\33[31m can not find file $UpgradeFile \33[0m"
	PrintLog "can not find file $UpgradeFile"
	exit 1;
else
	test -d $UpgradePath || mkdir -p $UpgradePath
	tar -zxvf "$UpgradeFile" -C $UpgradePath
	sleep 2
	cd $UpgradePath
	md5sum -c upgradeCheck.dat
	if [ "$?" != 0 ] ; then 
		PrintLog "$UpgradeFile file error md5sum fail"
		printf "\33[31m $UpgradeFile file error md5sum fail \33[0m"
		rm -rf $UpgradePath
		exit 1;
	fi
 
	export versionmd5=$(cat product.dat)
	echo $test

	export versionmd5e=$( echo -n "enterprise" | md5sum )
	export versionmd5s=$( echo -n "standard" | md5sum )
	export versionmd5su=$( echo -n "standard-ubuntu" | md5sum )
	export versionmd5suTS=$( echo -n "standard-ubuntu-TS" | md5sum )
	export versionmd5suPMS=$( echo -n "standard-ubuntu-PMS" | md5sum )
	export versionmd5euTYCO=$( echo -n "enterprise-ubuntu-TYCO" | md5sum )
	export versionmd5suTYCO=$( echo -n "standard-ubuntu-TYCO" | md5sum )
	export versionmd5eu20TYCO=$( echo -n "enterprise-ubuntu20-TYCO" | md5sum )
	export versionmd5su20TYCO=$( echo -n "standard-ubuntu20-TYCO" | md5sum )
	
	export versionmd5eu20=$( echo -n "enterprise-ubuntu20" | md5sum )
	export versionmd5su20=$( echo -n "standard-ubuntu20" | md5sum )

	if [[ $version_info =~ $version_ubutnu20 ]]; then
		if [ $2 == "A510-MTS" ] || [ $2 == "S300E" ] ; then
			if [ "$versionmd5" != "$versionmd5eu20" ] && [ "$versionmd5" != "$versionmd5su20" ]; then
				PrintLog "not enterprise-ubuntu20 or standard-ubuntu20 pack" "stdout"
				exit 1;
			fi
			echo "pass1"
		elif [ $2 == "A600SE" ] || [ $2 == "A510S-MS" ] || [ $2 == "A510S-MTC" ] ||  [ $2 == "A510S-MTSC" ] ; then
			if [ "$versionmd5" != "$versionmd5su20" ]; then
				PrintLog "not standard-ubuntu20 pack" "stdout"
				exit 1;
			fi
			echo "pass2"
		elif [ $2 == "TD-A608E" ] || [ $2 == "A300-MTC" ] || [ $2 == "A400-MTC" ]; then
			if [ $3 == "HVM-HCO2000" ]; then
				if [ "$versionmd5" != "$versionmd5eu20" ]; then
					PrintLog "HVM-HCO2000 not enterprise-ubuntu20 pack" "stdout"
					exit 1;
				fi
			elif [ "$versionmd5" != "$versionmd5su20" ]; then
				PrintLog "not standard-ubuntu20 pack" "stdout"
				exit 1;
			fi
			echo "pass3"
		else
			if [ "$versionmd5" != "$versionmd5eu20" ]; then
				PrintLog "not enterprise-ubuntu20 pack" "stdout"
				exit 1;
			fi
			echo "pass4"
		fi
	else
		if [ $2 == "A510-MTS" ] || [ $2 == "S300E" ] ; then
			if [ "$versionmd5" == "$versionmd5su" ]; then
				PrintLog "not enterprise or standard pack" "stdout"
				exit 1;
			fi
			echo "pass1"
		elif [ $2 == "A600SE" ] || [ $2 == "A510S-MS" ] || [ $2 == "A510S-MTC" ] ||  [ $2 == "A510S-MTSC" ] ; then
			if [ "$versionmd5" != "$versionmd5s" ]; then
				PrintLog "not standard pack" "stdout"
				exit 1;
			fi
			echo "pass2"
		elif [ $2 == "TD-A608E" ] || [ $2 == "A300-MTC" ] ; then
			if [ "$versionmd5" != "$versionmd5su" ]; then
				PrintLog "not standard-ubuntu pack" "stdout"
				exit 1;
			fi
			echo "pass3"
		elif [ $2 == "A300-TS" ] ; then
			if [ "$versionmd5" != "$versionmd5su" ]; then
				PrintLog "not standard-ubuntu pack"
				echo "not standard-ubuntu pack"
				exit 1;
			fi
			echo "pass4"
		elif [ $2 == "A300-PMS" ] ; then
			if [ "$versionmd5" != "$versionmd5suPMS" ]; then
				PrintLog "not standard-ubuntu pack" "stdout"
				exit 1;
			fi
			echo "pass5"
		elif [ $2 == "HVM-HSS2000L" ]  ; then
			if [ "$versionmd5" != "$versionmd5suTYCO" ]; then
				PrintLog "not standard-ubuntu-TYCO pack" "stdout"
				exit 1;
			fi
			echo "pass6"
		elif [ $2 == "HVM-HCO2000" ]  ; then
			if [ "$versionmd5" != "$versionmd5euTYCO" ]; then
				PrintLog "not standard-ubuntu-TYCO pack" "stdout"
				exit 1;
			fi
			echo "pass7"
		elif [ "$versionmd5" != "$versionmd5e" ]; then
			PrintLog "not enterprise pack" "stdout"
			exit 1;
		fi
	fi
fi

ZONION_INSTALLED=0
function check_zonion_install()
{
    if [ -d /home/zonion ]; then
        echo "/home/zonion exists"
        ZONION_INSTALLED=1
        echo "zonion installed"
    else
        echo "zonion not installed"
    fi
}

check_zonion_install

#StopServer #网页升级时会把提供web服务的配置服务停掉
/etc/init.d/ZlMedia-daemon stop
rm -rf /opt/NVMS/ZlMedia
rm -rf /opt/NVMS/lib
rm -rf /opt/NVMS/third_lib_64

PrintLog "run ${PreUpgradeSh} before"
sh ${PreUpgradeSh}
PrintLog "run ${PreUpgradeSh} after"

if [  -f $UpgradePath/appfs.tar.gz ]; then
	PrintLog "upgrade appfs" "stdout"
	cd $UpgradePath
	test -d /opt/NVMS || mkdir -p /opt/NVMS
	test -d /opt/NVMS/configInfo/Config && cp -rf /opt/NVMS/configInfo/Config /opt/NVMS/configInfo/Config_bak #备份配置文件
	#test -d /opt/NVMS/configInfo/Config_bak && rm -rf /opt/NVMS/configInfo/Config_bak/ConfigDevBasicServer.xml #暂时不能保留这个等这个程序修改
	#获取升级之前语言 
	test -e /opt/NVMS/Language/LanguageIndex.ini && varLanguageClient=`cat /opt/NVMS/Language/LanguageIndex.ini | grep languagesSel`
	test -e /opt/NVMS/language/LanguageIndex.ini && varLanguageServer=`cat /opt/NVMS/language/LanguageIndex.ini | grep languagesSel`
	echo "originalLanguageClient:$varLanguageClient"
	echo "originalLanguageServer:$varLanguageServer"
	rm -rf /opt/NVMS/DeviceWeb
	rm -rf /opt/NVMS/lib/libRtspClient.so #由于与华安的rtspClient库重名，NVMS的库名改成了libRtspClientEx.so，这里删除老的库
	rm -rf /opt/NVMS/lib
	rm -rf /opt/NVMS/lib64
	tar -zxvf appfs.tar.gz -C /opt/NVMS/
	sleep 3
	mv /opt/NVMS/*daemon /etc/init.d/
	mv /opt/NVMS/shutdown_os.sh /etc/init.d/
	mv /opt/NVMS/NVMS.conf /etc/ld.so.conf.d/
	mv /opt/NVMS/myctl_dhclient.sh /usr/bin/
	mv /opt/NVMS/myctl_dhclient6.sh /usr/bin/
	sync
	ldconfig #执行这句，部分mtc华安的库才能找到
	test -d /opt/apache-tomcat/webapps/ROOT/WEB-INF/classes/config.properties && cp /opt/apache-tomcat/webapps/ROOT/WEB-INF/classes/config.properties /opt/NVMS/WebRoot/WEB-INF/classes/config.properties #可能已被配置过端口，拷过去可能会覆盖掉
	
	PrintLog "version_info is $version_info" "stdout"
	PrintLog "version_centos is $version_centos" "stdout"
	if [[ $version_info =~ $version_ubutnu18 ]] || [[ $version_info =~ $version_centos ]]; then
		#apache-tomcat9.0.37---begin
		echo "copy apache_tomcat"
		mkdir /opt/apache-tomcat
		rm -rf /opt/apache-tomcat/webapps/ROOT/WEB-INF/lib/
		cp /opt/apache-tomcat/conf/server.xml /opt/
		cp -rf /opt/NVMS/apache-tomcat/* /opt/apache-tomcat/
		#apache-tomcat9.0.37---end	
		cp -rf /opt/NVMS/WebRoot/* /opt/apache-tomcat/webapps/ROOT/
		#cp /opt/server.xml /opt/apache-tomcat/conf/
		rm -rf /opt/NVMS/apache-tomcat/
		#rm /opt/server.xml	
	else
		cp /opt/NVMS/apache-tomcat/bin/catalina.sh /opt/apache-tomcat/bin/
		cp /opt/NVMS/apache-tomcat/bin/shutdown.sh /opt/apache-tomcat/bin/
	fi

	cp -rf /opt/NVMS/WebRoot/logging.properties /opt/apache-tomcat/conf/
	rm -rf /opt/NVMS/WebRoot/logging.properties
	rm -rf /opt/apache-tomcat/webapps/ROOT/WEB-INF/lib/
	cp -rf /opt/NVMS/WebRoot/* /opt/apache-tomcat/webapps/ROOT/
	chmod -R 777 /opt/apache-tomcat/*
	/opt/apache-tomcat/export.sh
	rm -rf /opt/NVMS/WebRoot
	rm -rf /opt/NVMS/3DGisMap
	rm -rf /opt/apache-tomcat/webapps/ROOT/WEB-INF/classes/log4j.properties
	rm -rf /opt/apache-tomcat/webapps/ROOT/WEB-INF/lib/log4j-1.2.17.jar
	rm -rf /opt/apache-tomcat/webapps/ROOT/WEB-INF/lib/log4j-api-2.0-rc1.jar
	rm -rf /opt/apache-tomcat/webapps/ROOT/WEB-INF/lib/log4j-core-2.0-rc1.jar
	rm -rf /opt/apache-tomcat/webapps/ROOT/WEB-INF/lib/slf4j-api-1.7.5.jar
	rm -rf /opt/apache-tomcat/webapps/ROOT/WEB-INF/lib/slf4j-log4j12-1.7.5.jar
	rm -rf /opt/apache-tomcat/webapps/ROOT/WEB-INF/classes/log4j.properties
	rm -rf /opt/apache-tomcat/webapps/docs
	rm -rf /opt/apache-tomcat/webapps/examples
	
	mv /opt/NVMS/configInfo/Config/log.properties /opt/NVMS/
	test -d /opt/NVMS/configInfo/Config_bak && cp -rf /opt/NVMS/configInfo/Config_bak/* /opt/NVMS/configInfo/Config/ #配置文件恢复
	test -d /opt/NVMS/configInfo/Config_bak && rm -rf /opt/NVMS/configInfo/Config_bak/
	
	#回写升级前语言
	if [ $varLanguageClient ]; then
	PrintLog "writeback LanguageClient::$varLanguageClient" "stdout"
	test -e /opt/NVMS/Language/LanguageIndex.ini &&  sed -i "s/languagesSel.*/$varLanguageClient/g" /opt/NVMS/Language/LanguageIndex.ini
	fi
	
	if [ $varLanguageServer ]; then
	PrintLog "writeback LanguageServer::$varLanguageServer" "stdout"
	test -e /opt/NVMS/language/LanguageIndex.ini &&  sed -i "s/languagesSel.*/$varLanguageServer/g" /opt/NVMS/language/LanguageIndex.ini
	fi
	#grep "$tomcat_start" $find_file && echo "find" || `funtomcat` #will by ConfigServer
	sed -i '/apache-tomcat/d' $find_file #add will by ConfigServer
	#grep "$config_start" $find_file && echo "find" || `funconfig`
	#找到$config_start要去掉
	
	grep "ldconfig" $find_file && echo "find" || `funexportLibPath`
	grep "ldconfig" $find_file_ex && echo "find" || `funexportLibPath_ex`
	
	sed -i 's/service ConfigDevBasicServer-daemon start//' $find_file
	sed -i 's/service ConfigDevBasicServer-daemon start//' $find_file_ex
	
	sed -i '/ConfigDevBasicServer/d' $find_file
	sed -i '/ConfigDevBasicServer/d' $find_file_ex
	
	grep "$config_ip_maintain" $find_file && echo "find" || `funipmaintainconfig`
	grep "$config_ip_maintain" $find_file_ex && echo "find" || `funipmaintainconfig_ex`
	grep "$config_start_process" $find_file && echo "find" || `funprocessconfig`
	grep "$config_start_process" $find_file_ex && echo "find" || `funprocessconfig_ex`

	grep "bonding" $file_etc_modules && echo "find bonding" || `funbond`
	mv /etc/init.d/lighttpd /etc/init.d/lighttpd-
	chmod +x /etc/rc.d/rc.local  #CentOS
	sync
	#ZONION的设备，拷贝所需环境库
	##if [ $ZONION_INSTALLED -eq 1 ]; then
	    #test -d /usr/lib32 || mkdir -p /usr/lib32
	    ##cp -rf /opt/NVMS/lib32/lib/i386-linux-gnu/* /lib32 
	    ##cp -rf /opt/NVMS/lib32/usr/lib/i386-linux-gnu/* /usr/lib32/
		#awk 'BEGIN { cmd="cp -ri /opt/NVMS/lib32/lib/i386-linux-gnu/* /usr/lib32/"; print "n" |cmd; }'
		#awk 'BEGIN { cmd="cp -ri /opt/NVMS/lib32/usr/lib/i386-linux-gnu/* /usr/lib32/"; print "n" |cmd; }'
	##fi
      rm -rf /opt/NVMS/libqwt.so.6.1
	rm -rf /opt/NVMS/libqwt.so.6
	rm -rf /opt/NVMS/libqwt.so
      ln -s /opt/NVMS/libqwt.so.6.1.4 /opt/NVMS/libqwt.so.6.1
	ln -s /opt/NVMS/libqwt.so.6.1.4 /opt/NVMS/libqwt.so.6
	ln -s /opt/NVMS/libqwt.so.6.1.4 /opt/NVMS/libqwt.so
	ldconfig
	grep "$ulimit_str" $find_profile && echo "find" || `funulimit`
fi

PrintLog "Product is $ProductType" "stdout"
echo "Product="$ProductType >> /opt/NVMS/AppPackInfo.ini
if [ $ProductType == "A600E" ] || [ $ProductType == "A600SE" ]; then
	PrintLog "A600E or A600SE" "stdout"
	#delete
	rm /opt/NVMS/MonitorClient
	rm /opt/NVMS/UpperCascadeGW
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/LowerGAT1400
	rm /opt/NVMS/UpperGAT1400Server
	rm -rf /opt/NVMS/MonitorClient_log
	rm -rf /opt/NVMS/UpperCascadeGW_log
	rm -rf /opt/NVMS/LowerCascadeGW_log
	rm -rf /opt/NVMS/RtspServerGW_log
	rm -rf /opt/NVMS/StreamServerGW_log
	rm -rf /opt/NVMS/websocket_rtsp_proxy_log
	rm -rf /opt/NVMS/LowerGAT1400_log
	rm -rf /opt/NVMS/UpperGAT1400Server_log
	rm /etc/init.d/MonitorClient-daemon
	rm /etc/init.d/UpperCascadeGW-daemon
	rm /etc/init.d/LowerCascadeGW-daemon
	rm /etc/init.d/RtspServerGW-daemon
	rm /etc/init.d/StreamServerGW-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/LowerGAT1400-daemon
	rm /etc/init.d/UpperGAT1400Server-daemon
	rm /opt/NVMS/configInfo/Config/UpperCascadeGW*
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/LowerGAT1400*
	rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*
	#raid
	mv /opt/NVMS/lib/libDiskManager.so /opt/NVMS/lib/libDiskManager_bak.so
	cp -f /opt/NVMS/lib/libDiskManager_raid.so /opt/NVMS/lib/libDiskManager.so
	mv /opt/NVMS/lib64/libDiskManager.so /opt/NVMS/lib64/libDiskManager_bak.so
	cp -f /opt/NVMS/lib64/libDiskManager_raid.so /opt/NVMS/lib64/libDiskManager.so
	
elif [ $ProductType == "S300E" ] || [ $ProductType == "S300SE" ]; then
	PrintLog "S300E or S300SE" "stdout"
	#raid
	mv /opt/NVMS/lib/libDiskManager.so /opt/NVMS/lib/libDiskManager_bak.so
	cp -f /opt/NVMS/lib/libDiskManager_raid.so /opt/NVMS/lib/libDiskManager.so
	mv /opt/NVMS/lib64/libDiskManager.so /opt/NVMS/lib64/libDiskManager_bak.so
	cp -f /opt/NVMS/lib64/libDiskManager_raid.so /opt/NVMS/lib64/libDiskManager.so
	#delete
	sed -i '/apache-tomcat/d' $find_file
	rm /opt/NVMS/MonitorClient
	rm /opt/NVMS/AuthenticationServer
	rm /opt/NVMS/ConfigServer
	rm /opt/NVMS/AlarmServer
	rm /opt/NVMS/JoinServer
	rm /opt/NVMS/TVWallServer
	rm /opt/NVMS/IntelligentAnalysisServer
	rm /opt/NVMS/UpperCascadeGW
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/LowerGAT1400
    rm /opt/NVMS/UpperGAT1400Server
	rm /opt/NVMS/ApplicationServer
    rm /opt/NVMS/PicWebServer
	rm -rf /opt/NVMS/MonitorClient_log
	rm -rf /opt/NVMS/AuthenticationServer_log
	rm -rf /opt/NVMS/ConfigServer_log
	rm -rf /opt/NVMS/AlarmServer_log
	rm -rf /opt/NVMS/JoinServer_log
	rm -rf /opt/NVMS/TVWallServer_log
	rm -rf /opt/NVMS/IntelligentAnalysisServer_log
	rm -rf /opt/NVMS/UpperCascadeGW_log
	rm -rf /opt/NVMS/LowerCascadeGW_log
	rm -rf /opt/NVMS/RtspServerGW_log
	rm -rf /opt/NVMS/StreamServerGW_log
	rm -rf /opt/NVMS/websocket_rtsp_proxy_log
	rm -rf /opt/NVMS/LowerGAT1400_log
    rm -rf /opt/NVMS/UpperGAT1400Server_log
	rm -rf /opt/NVMS/ApplicationServer_log
    rm -rf /opt/NVMS/PicWebServer_log
	rm /etc/init.d/MonitorClient-daemon
	rm /etc/init.d/AuthenticationServer-daemon
	rm /etc/init.d/ConfigServer-daemon
	rm /etc/init.d/AlarmServer-daemon
	rm /etc/init.d/JoinServer-daemon
	rm /etc/init.d/TVWallServer-daemon
	rm /etc/init.d/IntelligentAnalysisServer-daemon
	rm /etc/init.d/UpperCascadeGW-daemon
	rm /etc/init.d/LowerCascadeGW-daemon
	rm /etc/init.d/RtspServerGW-daemon
	rm /etc/init.d/StreamServerGW-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/LowerGAT1400-daemon
    rm /etc/init.d/UpperGAT1400Server-daemon
	rm /etc/init.d/ApplicationServer-daemon
    rm /etc/init.d/PicWebServer-daemon
	rm /opt/NVMS/configInfo/Config/AuthenticationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ConfigServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/AlarmServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/JoinServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/TVWallServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/IntelligentAnalysisServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/UpperCascadeGWAppParam.xml
	rm /opt/NVMS/configInfo/Config/LowerCascadeGWAppParam.xml
	rm /opt/NVMS/configInfo/Config/RtspServerGWAppParam.xml
	rm /opt/NVMS/configInfo/Config/StreamServerGWAppParam.xml
	rm /opt/NVMS/configInfo/Config/LowerGAT1400AppParam.xml
	rm /opt/NVMS/configInfo/Config/UpperGAT1400ServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ApplicationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/PicWebServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/UpperCascadeGW*
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/LowerGAT1400*
    rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*
	rm /opt/NVMS/configInfo/Config/ApplicationServer*
    rm /opt/NVMS/configInfo/Config/PicWebServer*
	rm /opt/NVMS/configInfo/Config/AuthenticationServer*
	rm /opt/NVMS/configInfo/Config/ConfigServer*
	rm /opt/NVMS/configInfo/Config/JoinServer*
	rm /opt/NVMS/configInfo/Config/AlarmServer*
	rm /opt/NVMS/configInfo/Config/TVWallServer*
	rm /opt/NVMS/configInfo/Config/IntelligentAnalysisServer*

elif [ $ProductType == "HVM-HRS2400" ]; then
	PrintLog "HVM-HRS2400" "stdout"
	#raid
	mv /opt/NVMS/lib/libDiskManager.so /opt/NVMS/lib/libDiskManager_bak.so
	cp -f /opt/NVMS/lib/libDiskManager_raid.so /opt/NVMS/lib/libDiskManager.so
	mv /opt/NVMS/lib64/libDiskManager.so /opt/NVMS/lib64/libDiskManager_bak.so
	cp -f /opt/NVMS/lib64/libDiskManager_raid.so /opt/NVMS/lib64/libDiskManager.so
	#delete
	sed -i '/apache-tomcat/d' $find_file
	rm /opt/NVMS/MonitorClient
	rm /opt/NVMS/AuthenticationServer
	rm /opt/NVMS/ConfigServer
	rm /opt/NVMS/AlarmServer
	rm /opt/NVMS/JoinServer
	rm /opt/NVMS/TVWallServer
	rm /opt/NVMS/IntelligentAnalysisServer
	rm /opt/NVMS/UpperCascadeGW
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/LowerGAT1400
    rm /opt/NVMS/UpperGAT1400Server
	rm /opt/NVMS/ApplicationServer
    rm /opt/NVMS/PicWebServer
	rm -rf /opt/NVMS/MonitorClient_log
	rm -rf /opt/NVMS/AuthenticationServer_log
	rm -rf /opt/NVMS/ConfigServer_log
	rm -rf /opt/NVMS/AlarmServer_log
	rm -rf /opt/NVMS/JoinServer_log
	rm -rf /opt/NVMS/TVWallServer_log
	rm -rf /opt/NVMS/IntelligentAnalysisServer_log
	rm -rf /opt/NVMS/UpperCascadeGW_log
	rm -rf /opt/NVMS/LowerCascadeGW_log
	rm -rf /opt/NVMS/RtspServerGW_log
	rm -rf /opt/NVMS/StreamServerGW_log
	rm -rf /opt/NVMS/websocket_rtsp_proxy_log
	rm -rf /opt/NVMS/LowerGAT1400_log
    rm -rf /opt/NVMS/UpperGAT1400Server_log
	rm -rf /opt/NVMS/ApplicationServer_log
    rm -rf /opt/NVMS/PicWebServer_log
	rm /etc/init.d/MonitorClient-daemon
	rm /etc/init.d/AuthenticationServer-daemon
	rm /etc/init.d/ConfigServer-daemon
	rm /etc/init.d/AlarmServer-daemon
	rm /etc/init.d/JoinServer-daemon
	rm /etc/init.d/TVWallServer-daemon
	rm /etc/init.d/IntelligentAnalysisServer-daemon
	rm /etc/init.d/UpperCascadeGW-daemon
	rm /etc/init.d/LowerCascadeGW-daemon
	rm /etc/init.d/RtspServerGW-daemon
	rm /etc/init.d/StreamServerGW-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/LowerGAT1400-daemon
    rm /etc/init.d/UpperGAT1400Server-daemon
	rm /etc/init.d/ApplicationServer-daemon
    rm /etc/init.d/PicWebServer-daemon
	rm /opt/NVMS/configInfo/Config/AuthenticationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ConfigServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/AlarmServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/JoinServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/TVWallServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/IntelligentAnalysisServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/UpperCascadeGWAppParam.xml
	rm /opt/NVMS/configInfo/Config/LowerCascadeGWAppParam.xml
	rm /opt/NVMS/configInfo/Config/RtspServerGWAppParam.xml
	rm /opt/NVMS/configInfo/Config/StreamServerGWAppParam.xml
	rm /opt/NVMS/configInfo/Config/LowerGAT1400AppParam.xml
	rm /opt/NVMS/configInfo/Config/UpperGAT1400ServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ApplicationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/PicWebServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/UpperCascadeGW*
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/LowerGAT1400*
    rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*
	rm /opt/NVMS/configInfo/Config/ApplicationServer*
    rm /opt/NVMS/configInfo/Config/PicWebServer*
	rm /opt/NVMS/configInfo/Config/AuthenticationServer*
	rm /opt/NVMS/configInfo/Config/ConfigServer*
	rm /opt/NVMS/configInfo/Config/JoinServer*
	rm /opt/NVMS/configInfo/Config/AlarmServer*
	rm /opt/NVMS/configInfo/Config/TVWallServer*
	rm /opt/NVMS/configInfo/Config/IntelligentAnalysisServer*
	
elif [ $ProductType == "A510-MS" ] || [ $ProductType == "A510S-MS" ]; then
	PrintLog "A510-MS or A510S-MS" "stdout"
	#delete
	rm /opt/NVMS/MonitorClient
	#rm /opt/NVMS/MediaTransferServer
	rm /opt/NVMS/StorageServer
	rm /opt/NVMS/UpperCascadeGW
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/LowerGAT1400
    rm /opt/NVMS/UpperGAT1400Server
	rm -rf /opt/NVMS/MonitorClient_log
	#rm -rf /opt/NVMS/MediaTransferServer_log
	rm -rf /opt/NVMS/StorageServer_log
	rm -rf /opt/NVMS/UpperCascadeGW_log
	rm -rf /opt/NVMS/LowerCascadeGW_log
	rm -rf /opt/NVMS/RtspServerGW_log
	rm -rf /opt/NVMS/StreamServerGW_log
	rm -rf /opt/NVMS/websocket_rtsp_proxy_log
	rm -rf /opt/NVMS/LowerGAT1400_log
    rm -rf /opt/NVMS/UpperGAT1400Server_log
	rm /etc/init.d/MonitorClient-daemon
	#rm /etc/init.d/MediaTransferServer-daemon
	rm /etc/init.d/StorageServer-daemon
	rm /etc/init.d/UpperCascadeGW-daemon
	rm /etc/init.d/LowerCascadeGW-daemon
	rm /etc/init.d/RtspServerGW-daemon
	rm /etc/init.d/StreamServerGW-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/LowerGAT1400-daemon
    rm /etc/init.d/UpperGAT1400Server-daemon
	#rm /opt/NVMS/configInfo/Config/MediaTransferServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/StorageServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/UpperCascadeGW*
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/LowerGAT1400*
    rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*
	
elif [ $ProductType == "HVM-HSS2100" ]; then
	PrintLog "HVM-HSS2100" "stdout"
	#delete
	rm /opt/NVMS/MonitorClient
	#rm /opt/NVMS/MediaTransferServer
	rm /opt/NVMS/StorageServer
	rm /opt/NVMS/UpperCascadeGW
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/LowerGAT1400
    rm /opt/NVMS/UpperGAT1400Server
	rm -rf /opt/NVMS/MonitorClient_log
	#rm -rf /opt/NVMS/MediaTransferServer_log
	rm -rf /opt/NVMS/StorageServer_log
	rm -rf /opt/NVMS/UpperCascadeGW_log
	rm -rf /opt/NVMS/LowerCascadeGW_log
	rm -rf /opt/NVMS/RtspServerGW_log
	rm -rf /opt/NVMS/StreamServerGW_log
	rm -rf /opt/NVMS/websocket_rtsp_proxy_log
	rm -rf /opt/NVMS/LowerGAT1400_log
    rm -rf /opt/NVMS/UpperGAT1400Server_log
	rm /etc/init.d/MonitorClient-daemon
	#rm /etc/init.d/MediaTransferServer-daemon
	rm /etc/init.d/StorageServer-daemon
	rm /etc/init.d/UpperCascadeGW-daemon
	rm /etc/init.d/LowerCascadeGW-daemon
	rm /etc/init.d/RtspServerGW-daemon
	rm /etc/init.d/StreamServerGW-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/LowerGAT1400-daemon
    rm /etc/init.d/UpperGAT1400Server-daemon
	#rm /opt/NVMS/configInfo/Config/MediaTransferServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/StorageServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/UpperCascadeGW*
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/LowerGAT1400*
    rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*
	
elif [ $ProductType == "A510-MTC" ] || [ $ProductType == "A510S-MTC" ] || [ $ProductType == "AVM-HDM2100" ]; then
	PrintLog "A510-MTC or A510S-MTC or AVM-HDM2100" "stdout"
	if [ $ProductType == "A510-MTC" ]; then
		echo "Product is A510-MTC"
		echo "Product=A510-MTC" >> /opt/NVMS/AppPackInfo.ini
	elif [ $ProductType == "HVM-HDM2100" ]; then
		echo "Product is HVM-HDM2100"
		echo "Product=HVM-HDM2100" >> /opt/NVMS/AppPackInfo.ini
	fi
	if [ $ProductType == "A510S-MTC" ]; then
		#if [ $SpecialType == "OC-MS-XL(1U)-V2" ] || [ $SpecialType == "OC-MS-XL(1U)" ]; then
		#将全词匹配改为模糊匹配
		if [[ $SpecialType == OC-MS-XL* ]]; then
			rm /opt/NVMS/JoinServer
			rm -rf /opt/NVMS/JoinServer_log
			rm /etc/init.d/JoinServer-daemon
			rm /opt/NVMS/configInfo/Config/JoinServerAppParam.xml
		fi
	fi
	#delete
	rm /opt/NVMS/StorageServer
	rm /opt/NVMS/UpperCascadeGW
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/LowerGAT1400
	rm /opt/NVMS/UpperGAT1400Server
	rm -rf /opt/NVMS/StorageServer_log
	rm -rf /opt/NVMS/UpperCascadeGW_log
	rm -rf /opt/NVMS/LowerCascadeGW_log
	rm -rf /opt/NVMS/RtspServerGW_log
	rm -rf /opt/NVMS/StreamServerGW_log
	rm -rf /opt/NVMS/websocket_rtsp_proxy_log
	rm -rf /opt/NVMS/LowerGAT1400_log
	rm -rf /opt/NVMS/UpperGAT1400Server_log
	rm /etc/init.d/StorageServer-daemon
	rm /etc/init.d/UpperCascadeGW-daemon
	rm /etc/init.d/LowerCascadeGW-daemon
	rm /etc/init.d/RtspServerGW-daemon
	rm /etc/init.d/StreamServerGW-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/LowerGAT1400-daemon
	rm /etc/init.d/UpperGAT1400Server-daemon
	rm /opt/NVMS/configInfo/Config/StorageServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/UpperCascadeGW*
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/LowerGAT1400*
	rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*

elif [ $ProductType == "A510-MTSC" ] || [ $ProductType == "A510S-MTSC" ] ; then
	PrintLog "A510-MTSC or A510S-MTSC" "stdout"
	if [ $ProductType == "A510S-MTSC" ]; then
		#if [ $SpecialType == "OC-MS-XL(1U)-V2" ] || [ $SpecialType == "OC-MS-XL(1U)" ]; then
		#将全词匹配改为模糊匹配
		if [[ $SpecialType == OC-MS-XL* ]]; then
			rm /opt/NVMS/JoinServer
			rm -rf /opt/NVMS/JoinServer_log
			rm /etc/init.d/JoinServer-daemon
			rm /opt/NVMS/configInfo/Config/JoinServerAppParam.xml
		fi
	fi
	#delete
	rm /opt/NVMS/UpperCascadeGW
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/LowerGAT1400
	rm /opt/NVMS/UpperGAT1400Server
	rm -rf /opt/NVMS/UpperCascadeGW_log
	rm -rf /opt/NVMS/LowerCascadeGW_log
	rm -rf /opt/NVMS/RtspServerGW_log
	rm -rf /opt/NVMS/StreamServerGW_log
	rm -rf /opt/NVMS/websocket_rtsp_proxy_log
	rm -rf /opt/NVMS/LowerGAT1400_log
	rm -rf /opt/NVMS/UpperGAT1400Server_log
	rm /etc/init.d/UpperCascadeGW-daemon
	rm /etc/init.d/LowerCascadeGW-daemon
	rm /etc/init.d/RtspServerGW-daemon
	rm /etc/init.d/StreamServerGW-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/LowerGAT1400-daemon
	rm /etc/init.d/UpperGAT1400Server-daemon
	rm /opt/NVMS/configInfo/Config/UpperCascadeGW*
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/LowerGAT1400*
	rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*

elif [ $ProductType == "A510-MTS" ]; then
	PrintLog "A510-MTS" "stdout"
	#delete
	sed -i '/apache-tomcat/d' $find_file
	rm /opt/NVMS/MonitorClient
	rm /opt/NVMS/AuthenticationServer
	rm /opt/NVMS/ConfigServer
	rm /opt/NVMS/StorageServer
	rm /opt/NVMS/AlarmServer
	rm /opt/NVMS/JoinServer
	rm /opt/NVMS/TVWallServer
	rm /opt/NVMS/IntelligentAnalysisServer
	rm /opt/NVMS/UpperCascadeGW
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/LowerGAT1400
    rm /opt/NVMS/UpperGAT1400Server
	rm /opt/NVMS/ApplicationServer
    rm /opt/NVMS/PicWebServer
	rm -rf /opt/NVMS/MonitorClient_log
	rm -rf /opt/NVMS/AuthenticationServer_log
	rm -rf /opt/NVMS/ConfigServer_log
	rm -rf /opt/NVMS/StorageServer_log
	rm -rf /opt/NVMS/AlarmServer_log
	rm -rf /opt/NVMS/JoinServer_log
	rm -rf /opt/NVMS/TVWallServer_log
	rm -rf /opt/NVMS/IntelligentAnalysisServer_log
	rm -rf /opt/NVMS/UpperCascadeGW_log
	rm -rf /opt/NVMS/LowerCascadeGW_log
	rm -rf /opt/NVMS/RtspServerGW_log
	rm -rf /opt/NVMS/StreamServerGW_log
	rm -rf /opt/NVMS/websocket_rtsp_proxy_log
	rm -rf /opt/NVMS/LowerGAT1400_log
    rm -rf /opt/NVMS/UpperGAT1400Server_log
	rm -rf /opt/NVMS/ApplicationServer_log
    rm -rf /opt/NVMS/PicWebServer_log
	rm /etc/init.d/MonitorClient-daemon
	rm /etc/init.d/AuthenticationServer-daemon
	rm /etc/init.d/ConfigServer-daemon
	rm /etc/init.d/StorageServer-daemon
	rm /etc/init.d/AlarmServer-daemon
	rm /etc/init.d/JoinServer-daemon
	rm /etc/init.d/TVWallServer-daemon
	rm /etc/init.d/IntelligentAnalysisServer-daemon
	rm /etc/init.d/UpperCascadeGW-daemon
	rm /etc/init.d/LowerCascadeGW-daemon
	rm /etc/init.d/RtspServerGW-daemon
	rm /etc/init.d/StreamServerGW-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/LowerGAT1400-daemon
    rm /etc/init.d/UpperGAT1400Server-daemon
	rm /etc/init.d/ApplicationServer-daemon
    rm /etc/init.d/PicWebServer-daemon
	rm /opt/NVMS/configInfo/Config/AuthenticationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/StorageServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ConfigServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/AlarmServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/JoinServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/TVWallServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/IntelligentAnalysisServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ApplicationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/PicWebServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/UpperCascadeGW*
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/LowerGAT1400*
    rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*
	rm /opt/NVMS/configInfo/Config/ApplicationServer*
    rm /opt/NVMS/configInfo/Config/PicWebServer*
	
elif [ $ProductType == "HVM-HMS2100" ]; then
	PrintLog "HVM-HMS2100" "stdout"
	#delete
	sed -i '/apache-tomcat/d' $find_file
	rm /opt/NVMS/MonitorClient
	rm /opt/NVMS/AuthenticationServer
	rm /opt/NVMS/ConfigServer
	rm /opt/NVMS/StorageServer
	rm /opt/NVMS/AlarmServer
	rm /opt/NVMS/JoinServer
	rm /opt/NVMS/TVWallServer
	rm /opt/NVMS/IntelligentAnalysisServer
	rm /opt/NVMS/UpperCascadeGW
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/LowerGAT1400
    rm /opt/NVMS/UpperGAT1400Server
	rm /opt/NVMS/ApplicationServer
    rm /opt/NVMS/PicWebServer
	rm -rf /opt/NVMS/MonitorClient_log
	rm -rf /opt/NVMS/AuthenticationServer_log
	rm -rf /opt/NVMS/ConfigServer_log
	rm -rf /opt/NVMS/StorageServer_log
	rm -rf /opt/NVMS/AlarmServer_log
	rm -rf /opt/NVMS/JoinServer_log
	rm -rf /opt/NVMS/TVWallServer_log
	rm -rf /opt/NVMS/IntelligentAnalysisServer_log
	rm -rf /opt/NVMS/UpperCascadeGW_log
	rm -rf /opt/NVMS/LowerCascadeGW_log
	rm -rf /opt/NVMS/RtspServerGW_log
	rm -rf /opt/NVMS/StreamServerGW_log
	rm -rf /opt/NVMS/websocket_rtsp_proxy_log
	rm -rf /opt/NVMS/LowerGAT1400_log
    rm -rf /opt/NVMS/UpperGAT1400Server_log
	rm -rf /opt/NVMS/ApplicationServer_log
    rm -rf /opt/NVMS/PicWebServer_log
	rm /etc/init.d/MonitorClient-daemon
	rm /etc/init.d/AuthenticationServer-daemon
	rm /etc/init.d/ConfigServer-daemon
	rm /etc/init.d/StorageServer-daemon
	rm /etc/init.d/AlarmServer-daemon
	rm /etc/init.d/JoinServer-daemon
	rm /etc/init.d/TVWallServer-daemon
	rm /etc/init.d/IntelligentAnalysisServer-daemon
	rm /etc/init.d/UpperCascadeGW-daemon
	rm /etc/init.d/LowerCascadeGW-daemon
	rm /etc/init.d/RtspServerGW-daemon
	rm /etc/init.d/StreamServerGW-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/LowerGAT1400-daemon
    rm /etc/init.d/UpperGAT1400Server-daemon
	rm /etc/init.d/ApplicationServer-daemon
    rm /etc/init.d/PicWebServer-daemon
	rm /opt/NVMS/configInfo/Config/AuthenticationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/StorageServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ConfigServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/AlarmServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/JoinServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/TVWallServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/IntelligentAnalysisServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ApplicationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/PicWebServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/UpperCascadeGW*
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/LowerGAT1400*
    rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*
	rm /opt/NVMS/configInfo/Config/ApplicationServer*
    rm /opt/NVMS/configInfo/Config/PicWebServer*
	
elif [ $ProductType == "A510-SGW" ] || [ $ProductType == "HVM-HGS2100" ]; then
	PrintLog "A510-SGW or HVM-HGS2100" "stdout"
	#delete
	sed -i '/apache-tomcat/d' $find_file
	rm /opt/NVMS/MonitorClient
	rm /opt/NVMS/AuthenticationServer
	rm /opt/NVMS/ConfigServer
	rm /opt/NVMS/StorageServer
	rm /opt/NVMS/AlarmServer
	rm /opt/NVMS/JoinServer
	rm /opt/NVMS/TVWallServer
	rm /opt/NVMS/IntelligentAnalysisServer
	rm /opt/NVMS/MediaTransferServer
	rm /opt/NVMS/UpperCascadeGW
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/LowerGAT1400
    rm /opt/NVMS/UpperGAT1400Server
	rm /opt/NVMS/ApplicationServer
    rm /opt/NVMS/PicWebServer
	rm -rf /opt/NVMS/MonitorClient_log
	rm -rf /opt/NVMS/AuthenticationServer_log
	rm -rf /opt/NVMS/ConfigServer_log
	rm -rf /opt/NVMS/StorageServer_log
	rm -rf /opt/NVMS/AlarmServer_log
	rm -rf /opt/NVMS/JoinServer_log
	rm -rf /opt/NVMS/TVWallServer_log
	rm -rf /opt/NVMS/IntelligentAnalysisServer_log
	rm -rf /opt/NVMS/MediaTransferServer_log
	rm -rf /opt/NVMS/UpperCascadeGW_log
	rm -rf /opt/NVMS/LowerCascadeGW_log
	rm -rf /opt/NVMS/LowerGAT1400_log
    rm -rf /opt/NVMS/UpperGAT1400Server_log
	rm -rf /opt/NVMS/ApplicationServer_log
    rm -rf /opt/NVMS/PicWebServer_log
	rm /etc/init.d/MonitorClient-daemon
	rm /etc/init.d/AuthenticationServer-daemon
	rm /etc/init.d/ConfigServer-daemon
	rm /etc/init.d/StorageServer-daemon
	rm /etc/init.d/AlarmServer-daemon
	rm /etc/init.d/JoinServer-daemon
	rm /etc/init.d/TVWallServer-daemon
	rm /etc/init.d/IntelligentAnalysisServer-daemon
	rm /etc/init.d/MediaTransferServer-daemon
	rm /etc/init.d/UpperCascadeGW-daemon
	rm /etc/init.d/LowerCascadeGW-daemon
	rm /etc/init.d/LowerGAT1400-daemon
    rm /etc/init.d/UpperGAT1400Server-daemon
	rm /etc/init.d/ApplicationServer-daemon
    rm /etc/init.d/PicWebServer-daemon
	rm /opt/NVMS/configInfo/Config/AuthenticationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/StorageServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ConfigServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/AlarmServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/JoinServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/TVWallServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/IntelligentAnalysisServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/MediaTransferServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ApplicationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/PicWebServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/UpperCascadeGW*
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/LowerGAT1400*
    rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*
	rm /opt/NVMS/configInfo/Config/ApplicationServer*
    rm /opt/NVMS/configInfo/Config/PicWebServer*
	
elif [ $ProductType == "A510-LGW" ]; then
	PrintLog "A510-LGW" "stdout"
	#delete
	sed -i '/apache-tomcat/d' $find_file
	rm /opt/NVMS/MonitorClient
	rm /opt/NVMS/AuthenticationServer
	rm /opt/NVMS/ConfigServer
	rm /opt/NVMS/StorageServer
	rm /opt/NVMS/AlarmServer
	rm /opt/NVMS/JoinServer
	rm /opt/NVMS/TVWallServer
	rm /opt/NVMS/IntelligentAnalysisServer
	rm /opt/NVMS/MediaTransferServer
	rm /opt/NVMS/UpperCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/LowerGAT1400
    rm /opt/NVMS/UpperGAT1400Server
	rm /opt/NVMS/ApplicationServer
    rm /opt/NVMS/PicWebServer
	rm -rf /opt/NVMS/MonitorClient_log
	rm -rf /opt/NVMS/AuthenticationServer_log
	rm -rf /opt/NVMS/ConfigServer_log
	rm -rf /opt/NVMS/StorageServer_log
	rm -rf /opt/NVMS/AlarmServer_log
	rm -rf /opt/NVMS/JoinServer_log
	rm -rf /opt/NVMS/TVWallServer_log
	rm -rf /opt/NVMS/IntelligentAnalysisServer_log
	rm -rf /opt/NVMS/MediaTransferServer_log
	rm -rf /opt/NVMS/UpperCascadeGW_log
	rm -rf /opt/NVMS/RtspServerGW_log
	rm -rf /opt/NVMS/StreamServerGW_log
	rm -rf /opt/NVMS/websocket_rtsp_proxy_log
	rm -rf /opt/NVMS/LowerGAT1400_log
    rm -rf /opt/NVMS/UpperGAT1400Server_log
	rm -rf /opt/NVMS/ApplicationServer_log
    rm -rf /opt/NVMS/PicWebServer_log
	rm /etc/init.d/MonitorClient-daemon
	rm /etc/init.d/AuthenticationServer-daemon
	rm /etc/init.d/ConfigServer-daemon
	rm /etc/init.d/StorageServer-daemon
	rm /etc/init.d/AlarmServer-daemon
	rm /etc/init.d/JoinServer-daemon
	rm /etc/init.d/TVWallServer-daemon
	rm /etc/init.d/IntelligentAnalysisServer-daemon
	rm /etc/init.d/MediaTransferServer-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/UpperCascadeGW-daemon
	rm /etc/init.d/RtspServerGW-daemon
	rm /etc/init.d/StreamServerGW-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/LowerGAT1400-daemon
    rm /etc/init.d/UpperGAT1400Server-daemon
	rm /etc/init.d/ApplicationServer-daemon
    rm /etc/init.d/PicWebServer-daemon
	rm /opt/NVMS/configInfo/Config/AuthenticationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/StorageServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ConfigServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/AlarmServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/JoinServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/TVWallServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/IntelligentAnalysisServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/MediaTransferServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ApplicationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/PicWebServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/UpperCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/LowerGAT1400*
    rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*
	rm /opt/NVMS/configInfo/Config/ApplicationServer*
    rm /opt/NVMS/configInfo/Config/PicWebServer*
	
elif [ $ProductType == "A510-UGW" ]; then
	PrintLog "A510-UGW" "stdout"
	#delete
	sed -i '/apache-tomcat/d' $find_file
	rm /opt/NVMS/MonitorClient
	rm /opt/NVMS/AuthenticationServer
	rm /opt/NVMS/ConfigServer
	rm /opt/NVMS/StorageServer
	rm /opt/NVMS/AlarmServer
	rm /opt/NVMS/JoinServer
	rm /opt/NVMS/TVWallServer
	rm /opt/NVMS/IntelligentAnalysisServer
	rm /opt/NVMS/MediaTransferServer
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/LowerGAT1400
    rm /opt/NVMS/UpperGAT1400Server
	rm /opt/NVMS/ApplicationServer
    rm /opt/NVMS/PicWebServer
	rm -rf /opt/NVMS/MonitorClient_log
	rm -rf /opt/NVMS/AuthenticationServer_log
	rm -rf /opt/NVMS/ConfigServer_log
	rm -rf /opt/NVMS/StorageServer_log
	rm -rf /opt/NVMS/AlarmServer_log
	rm -rf /opt/NVMS/JoinServer_log
	rm -rf /opt/NVMS/TVWallServer_log
	rm -rf /opt/NVMS/IntelligentAnalysisServer_log
	rm -rf /opt/NVMS/MediaTransferServer_log
	rm -rf /opt/NVMS/LowerCascadeGW_log
	rm -rf /opt/NVMS/RtspServerGW_log
	rm -rf /opt/NVMS/StreamServerGW_log
	rm -rf /opt/NVMS/websocket_rtsp_proxy_log
	rm -rf /opt/NVMS/LowerGAT1400_log
    rm -rf /opt/NVMS/UpperGAT1400Server_log
	rm -rf /opt/NVMS/ApplicationServer_log
    rm -rf /opt/NVMS/PicWebServer_log
	rm /etc/init.d/MonitorClient-daemon
	rm /etc/init.d/AuthenticationServer-daemon
	rm /etc/init.d/ConfigServer-daemon
	rm /etc/init.d/StorageServer-daemon
	rm /etc/init.d/AlarmServer-daemon
	rm /etc/init.d/JoinServer-daemon
	rm /etc/init.d/TVWallServer-daemon
	rm /etc/init.d/IntelligentAnalysisServer-daemon
	rm /etc/init.d/MediaTransferServer-daemon
	rm /etc/init.d/LowerCascadeGW-daemon
	rm /etc/init.d/RtspServerGW-daemon
	rm /etc/init.d/StreamServerGW-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/LowerGAT1400-daemon
    rm /etc/init.d/UpperGAT1400Server-daemon
	rm /etc/init.d/ApplicationServer-daemon
    rm /etc/init.d/PicWebServer-daemon
	rm /opt/NVMS/configInfo/Config/AuthenticationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/StorageServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ConfigServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/AlarmServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/JoinServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/TVWallServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/IntelligentAnalysisServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/MediaTransferServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ApplicationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/PicWebServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/LowerGAT1400*
    rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*
	rm /opt/NVMS/configInfo/Config/ApplicationServer*
    rm /opt/NVMS/configInfo/Config/PicWebServer*
    
elif [ $ProductType == "A510-DGW" ]; then
	PrintLog "A510-DGW" "stdout"
	echo "Product=A510-DGW" >> /opt/NVMS/AppPackInfo.ini
	#delete
	sed -i '/apache-tomcat/d' $find_file
	rm /opt/NVMS/MonitorClient
	rm /opt/NVMS/AuthenticationServer
	rm /opt/NVMS/ConfigServer
	rm /opt/NVMS/StorageServer
	rm /opt/NVMS/AlarmServer
	rm /opt/NVMS/JoinServer
	rm /opt/NVMS/TVWallServer
	rm /opt/NVMS/IntelligentAnalysisServer
	rm /opt/NVMS/MediaTransferServer
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/UpperCascadeGW
	rm /opt/NVMS/ApplicationServer
    rm /opt/NVMS/PicWebServer
	rm -rf /opt/NVMS/MonitorClient_log
	rm -rf /opt/NVMS/AuthenticationServer_log
	rm -rf /opt/NVMS/ConfigServer_log
	rm -rf /opt/NVMS/StorageServer_log
	rm -rf /opt/NVMS/AlarmServer_log
	rm -rf /opt/NVMS/JoinServer_log
	rm -rf /opt/NVMS/TVWallServer_log
	rm -rf /opt/NVMS/IntelligentAnalysisServer_log
	rm -rf /opt/NVMS/MediaTransferServer_log
	rm -rf /opt/NVMS/LowerCascadeGW_log
	rm -rf /opt/NVMS/RtspServerGW_log
	rm -rf /opt/NVMS/StreamServerGW_log
	rm -rf /opt/NVMS/websocket_rtsp_proxy_log
	rm -rf /opt/NVMS/UpperCascadeGW_log
	rm -rf /opt/NVMS/ApplicationServer_log
    rm -rf /opt/NVMS/PicWebServer_log
	rm /etc/init.d/MonitorClient-daemon
	rm /etc/init.d/AuthenticationServer-daemon
	rm /etc/init.d/ConfigServer-daemon
	rm /etc/init.d/StorageServer-daemon
	rm /etc/init.d/AlarmServer-daemon
	rm /etc/init.d/JoinServer-daemon
	rm /etc/init.d/TVWallServer-daemon
	rm /etc/init.d/IntelligentAnalysisServer-daemon
	rm /etc/init.d/MediaTransferServer-daemon
	rm /etc/init.d/LowerCascadeGW-daemon
	rm /etc/init.d/RtspServerGW-daemon
	rm /etc/init.d/StreamServerGW-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/ApplicationServer-daemon
    rm /etc/init.d/PicWebServer-daemon
	rm /opt/NVMS/configInfo/Config/AuthenticationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/StorageServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ConfigServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/AlarmServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/JoinServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/TVWallServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/IntelligentAnalysisServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/MediaTransferServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/ApplicationServer*
    rm /opt/NVMS/configInfo/Config/PicWebServer*
	
elif [ $ProductType == "HVM-HCO2000" ]; then
	PrintLog "HVM-HCO2000" "stdout"
	rm /opt/NVMS/AuthenticationServer
	rm /opt/NVMS/ConfigServer
	rm /opt/NVMS/StorageServer
	rm /opt/NVMS/AlarmServer
	rm /opt/NVMS/JoinServer
	rm /opt/NVMS/TVWallServer
	rm /opt/NVMS/IntelligentAnalysisServer
	rm /opt/NVMS/MediaTransferServer
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/LowerGAT1400
    rm /opt/NVMS/UpperGAT1400Server
	rm /opt/NVMS/ApplicationServer
	rm /opt/NVMS/PicWebServer
	rm -rf /opt/NVMS/AuthenticationServer_log
	rm -rf /opt/NVMS/ConfigServer_log
	rm -rf /opt/NVMS/StorageServer_log
	rm -rf /opt/NVMS/AlarmServer_log
	rm -rf /opt/NVMS/JoinServer_log
	rm -rf /opt/NVMS/TVWallServer_log
	rm -rf /opt/NVMS/IntelligentAnalysisServer_log
	rm -rf /opt/NVMS/MediaTransferServer_log
	rm -rf /opt/NVMS/LowerCascadeGW_log
	rm -rf /opt/NVMS/RtspServerGW_log
	rm -rf /opt/NVMS/StreamServerGW_log
	rm -rf /opt/NVMS/websocket_rtsp_proxy_log
	rm -rf /opt/NVMS/LowerGAT1400_log
    rm -rf /opt/NVMS/UpperGAT1400Server_log
	rm -rf /opt/NVMS/ApplicationServer_log
	rm -rf /opt/NVMS/PicWebServer_log
	rm /etc/init.d/AuthenticationServer-daemon
	rm /etc/init.d/ConfigServer-daemon
	rm /etc/init.d/StorageServer-daemon
	rm /etc/init.d/AlarmServer-daemon
	rm /etc/init.d/JoinServer-daemon
	rm /etc/init.d/TVWallServer-daemon
	rm /etc/init.d/IntelligentAnalysisServer-daemon
	rm /etc/init.d/MediaTransferServer-daemon
	rm /etc/init.d/LowerCascadeGW-daemon
	rm /etc/init.d/RtspServerGW-daemon
	rm /etc/init.d/StreamServerGW-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/LowerGAT1400-daemon
    rm /etc/init.d/UpperGAT1400Server-daemon
	rm /etc/init.d/ApplicationServer-daemon
	rm /etc/init.d/PicWebServer-daemon
	rm /opt/NVMS/configInfo/Config/AuthenticationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/StorageServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ConfigServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/AlarmServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/JoinServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/TVWallServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/IntelligentAnalysisServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/MediaTransferServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ApplicationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/PicWebServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/LowerGAT1400*
    rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*
	rm /opt/NVMS/configInfo/Config/ApplicationServer*
	rm /opt/NVMS/configInfo/Config/PicWebServer*
		
elif [ $ProductType == "A300-MTC" ] || [ $ProductType == "HVM-HSS2000L" ] ; then
	PrintLog "A300-MTC or HVM-HSS2000L" "stdout"
	#delete
	rm /opt/NVMS/StorageServer
	rm /opt/NVMS/UpperCascadeGW
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/UpperGAT1400Server
	rm -rf /opt/NVMS/StorageServer_log
	rm -rf /opt/NVMS/UpperCascadeGW_log
	rm -rf /opt/NVMS/LowerCascadeGW_log
	rm -rf /opt/NVMS/RtspServerGW_log
	rm -rf /opt/NVMS/StreamServerGW_log
	rm -rf /opt/NVMS/websocket_rtsp_proxy_log
	rm -rf /opt/NVMS/UpperGAT1400Server_log
	rm /etc/init.d/StorageServer-daemon
	rm /etc/init.d/UpperCascadeGW-daemon
	rm /etc/init.d/LowerCascadeGW-daemon
	rm /etc/init.d/RtspServerGW-daemon
	rm /etc/init.d/StreamServerGW-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/UpperGAT1400Server-daemon
	rm /opt/NVMS/configInfo/Config/StorageServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/UpperCascadeGW*
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*
	
	if [ $SpecialType != "YT-iVMSC01" ]; then
		rm /opt/NVMS/LowerGAT1400
		rm -rf /opt/NVMS/LowerGAT1400_log
		rm /etc/init.d/LowerGAT1400-daemon
		rm /opt/NVMS/configInfo/Config/LowerGAT1400*
	fi
	
	#if [ $SpecialType == "OC-MSCL-S(DT)-V2" ] || [ $SpecialType == "OC-MSCL-S(DT)" ]; then
	#将全词匹配改为模糊匹配
	if [[ $SpecialType == OC-MSCL-S* ]]; then
		rm /opt/NVMS/JoinServer
		rm -rf /opt/NVMS/JoinServer_log
		rm /etc/init.d/JoinServer-daemon
		rm /opt/NVMS/configInfo/Config/JoinServerAppParam.xml
	fi	
elif [ $ProductType == "TD-A608E" ] || [ $ProductType == "A400-MTC" ] ; then
	PrintLog "TD-A608E or A400-MTC" "stdout"
	#delete
	rm /opt/NVMS/UpperCascadeGW
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/LowerGAT1400
    rm /opt/NVMS/UpperGAT1400Server
	rm -rf /opt/NVMS/UpperCascadeGW_log
	rm -rf /opt/NVMS/LowerCascadeGW_log
	rm -rf /opt/NVMS/RtspServerGW_log
	rm -rf /opt/NVMS/StreamServerGW_log
	rm -rf /opt/NVMS/websocket_rtsp_proxy_log
	rm -rf /opt/NVMS/LowerGAT1400_log
    rm -rf /opt/NVMS/UpperGAT1400Server_log
	rm /etc/init.d/UpperCascadeGW-daemon
	rm /etc/init.d/LowerCascadeGW-daemon
	rm /etc/init.d/RtspServerGW-daemon
	rm /etc/init.d/StreamServerGW-daemon
	rm /etc/init.d/websocket_rtsp_proxy-daemon
	rm /etc/init.d/LowerGAT1400-daemon
    rm /etc/init.d/UpperGAT1400Server-daemon
	rm /opt/NVMS/configInfo/Config/UpperCascadeGW*
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/LowerGAT1400*
    rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*
	 if [ $ProductType == "TD-A608E" ] ; then
		rm /opt/NVMS/JoinServer
		rm -rf /opt/NVMS/JoinServer_log
		rm /etc/init.d/JoinServer-daemon
		rm /opt/NVMS/configInfo/Config/JoinServerAppParam.xml
		rm /opt/NVMS/ApplicationServer
		rm -rf /opt/NVMS/ApplicationServer_log
		rm /etc/init.d/ApplicationServer-daemon
		rm /opt/NVMS/configInfo/Config/ApplicationServerAppParam.xml
		rm /opt/NVMS/PicWebServer
		rm -rf /opt/NVMS/PicWebServer_log
		rm /etc/init.d/PicWebServer-daemon
		rm /opt/NVMS/configInfo/Config/PicWebServerAppParam.xml
	fi
	
	if [ $SpecialType == "OC-MS-M(1U)" ] ; then
		rm /opt/NVMS/JoinServer
		rm -rf /opt/NVMS/JoinServer_log
		rm /etc/init.d/JoinServer-daemon
		rm /opt/NVMS/configInfo/Config/JoinServerAppParam.xml
	fi
else 
	PrintLog "Other product" "stdout"
	rm /opt/NVMS/MonitorClient
	rm /opt/NVMS/AuthenticationServer
	rm /opt/NVMS/ConfigServer
	rm /opt/NVMS/StorageServer
	rm /opt/NVMS/AlarmServer
	rm /opt/NVMS/JoinServer
	rm /opt/NVMS/TVWallServer
	rm /opt/NVMS/IntelligentAnalysisServer
	rm /opt/NVMS/MediaTransferServer
	rm /opt/NVMS/UpperCascadeGW
	rm /opt/NVMS/LowerCascadeGW
	rm /opt/NVMS/RtspServerGW
	rm /opt/NVMS/StreamServerGW
	rm /opt/NVMS/websocket_rtsp_proxy
	rm /opt/NVMS/LowerGAT1400
    rm /opt/NVMS/UpperGAT1400Server
	rm /opt/NVMS/ApplicationServer
	rm /opt/NVMS/PicWebServer
	rm /etc/init.d/ApplicationServer-daemon
	rm /etc/init.d/PicWebServer-daemon
	rm /opt/NVMS/configInfo/Config/AuthenticationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/StorageServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ConfigServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/AlarmServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/JoinServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/TVWallServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/IntelligentAnalysisServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/MediaTransferServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/ApplicationServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/PicWebServerAppParam.xml
	rm /opt/NVMS/configInfo/Config/LowerCascadeGW*
	rm /opt/NVMS/configInfo/Config/RtspServerGW*
	rm /opt/NVMS/configInfo/Config/StreamServerGW*
	rm /opt/NVMS/configInfo/Config/websocket_proxy*
	rm /opt/NVMS/configInfo/Config/LowerGAT1400*
    rm /opt/NVMS/configInfo/Config/UpperGAT1400Server*
	rm /opt/NVMS/configInfo/Config/ApplicationServer*
	rm /opt/NVMS/configInfo/Config/PicWebServer*
fi

# delete library freeimage
PrintLog "delete library freeimage..."
rm -rf /opt/NVMS/lib64/libFreeImage.so

# delete library old openssl
# ubuntu使用openssl-1.1.1g
lsb_release -a 2>/dev/null |grep "^Distributor.*Ubuntu" 1>/dev/null
if [ $? -eq 0 ]; then
	PrintLog "rm /opt/NVMS/third_lib_64/Openssl1_0_2k ..."
	rm -rf /opt/NVMS/third_lib_64/Openssl1_0_2k
fi
# CentOS使用openssl-1.0.2k
lsb_release -a 2>/dev/null |grep "^Distributor.*CentOS" 1>/dev/null
if [ $? -eq 0 ]; then
	PrintLog "rm /opt/NVMS/third_lib_64/openssl-1.1.1g ..."
	rm -rf /opt/NVMS/third_lib_64/openssl-1.1.1g
fi
# Ubuntu20.04删除libfreetype.so库（安装包没有，但是如果是从2.1.2升级上来，此目录就会有，导致freetype链接到此目录而不是系统目录）
lsb_release -a 2>/dev/null |grep "^Description.*Ubuntu 20.04" 1>/dev/null
if [ $? -eq 0 ]; then
	PrintLog "rm /opt/NVMS/third_lib_64/Lib/libfreetype.* ..."
	rm -rf /opt/NVMS/third_lib_64/Lib/libfreetype.*
fi

# 替换tomcat使用的jar包（不做备份）
PrintLog "mv  -f  /opt/NVMS/catalina.jar  /opt/apache-tomcat/lib/"
mv  -f  /opt/NVMS/catalina.jar  /opt/apache-tomcat/lib/

if [[ $version_info =~ $version_ubutnu20 ]]; then
	PrintLog "dpkg -i  /opt/NVMS/third_lib_64/libxtst-deb/libxtst-dev_1.2.3-1_amd64.deb ..."
	dpkg -i  /opt/NVMS/third_lib_64/libxtst-deb/libxtst-dev_1.2.3-1_amd64.deb
fi

PrintLog "rm /opt/NVMS/DatPlayer/hi_mjpeg_dec_w.dll ..."
rm /opt/NVMS/DatPlayer/hi_mjpeg_dec_w.dll
ldconfig

if [ -n "$3" ] ; then
	echo "CustomerModel="$3 >> /opt/NVMS/AppPackInfo.ini
else
	echo "CustomerModel="$CustomName >> /opt/NVMS/AppPackInfo.ini
fi


chmod +rx /opt/NVMS/MTCProduction
/opt/NVMS/MTCProduction -2

#remove old DatPlayer files
rm -rf /opt/NVMS/DatPlayer/image
rm -rf /opt/NVMS/DatPlayer/DatPlayer
rm -rf /opt/NVMS/DatPlayer/DatPlayer.exe
rm -rf /opt/NVMS/DatPlayer/DatPlayer.pdb

ldconfig

#Check Point Agent
if [ -f $UpgradePath/cp-provision-integration-vms.sh ]  && [ -f $UpgradePath/cp_agent_ctrl.sh ] ; then
    echo "Check Point Agent"
    cp $UpgradePath/cp-provision-integration-vms.sh /opt/NVMS/
    cp $UpgradePath/cp_agent_ctrl.sh /opt/NVMS/
    chmod +x /opt/NVMS/cp-provision-integration-vms.sh
    chmod +x /opt/NVMS/cp_agent_ctrl.sh
#    cp /opt/NVMS/cp_agent_ctrl.sh /opt/NVMS/cp_agent_ctrl_uninstall.sh
    $UpgradePath/cp_agent_ctrl.sh --install

    if [ -f /usr/lib/libwlp-core.so ]; then
        # cp安装成功，则设置LD_PRELOAD
           sed -i "2i $agent_cp" $find_file
           sed -i "3i /opt/NVMS/cp_agent_ctrl.sh --wlp-clean" $find_file
    fi
fi

CP_AGENT_HASH_PATH=/etc/cp/workloadProtection/hashes/
if [ -d $CP_AGENT_HASH_PATH ] ; then
    rm -f $CP_AGENT_HASH_PATH/*
    #tar -zxvf $UpgradePath/cp-agent-hashes.tar.gz -C $CP_AGENT_HASH_PATH
fi

printf "\33[33m done.\33[0m\n"
PrintLog "upgrade.sh complete."
PrintLog "###############################################################"
